<?php

namespace App\Http\Controllers\Saas;

use App\Contracts\Saas\PaymentGateway;
use App\Http\Requests\Saas\SubscriptionRequest;
use App\Http\Resources\Saas\SubscriptionResource;
use App\Models\Saas\Subscription;
use App\Services\Saas\SubscriptionListService;
use App\Services\Saas\SubscriptionService;
use Illuminate\Http\Request;

class SubscriptionController
{
    public function preRequisite(Request $request, SubscriptionService $service)
    {
        return response()->ok($service->preRequisite($request));
    }

    public function index(Request $request, SubscriptionListService $service)
    {
        return $service->paginate($request);
    }

    public function calculate(SubscriptionRequest $request, SubscriptionService $service)
    {
        return $service->calculate($request);
    }

    public function initiate(SubscriptionRequest $request, SubscriptionService $service, PaymentGateway $paymentGateway)
    {
        $data = $service->initiate($request, $paymentGateway);

        if (is_array($data)) {
            return $data;
        }

        return response()->success([
            'message' => trans('global.created', ['attribute' => trans('saas.subscription.subscription')]),
            'subscription' => SubscriptionResource::make($data),
        ]);
    }

    public function store(Request $request, SubscriptionService $service, PaymentGateway $paymentGateway)
    {
        $subscription = $service->create($request, $paymentGateway);

        return response()->success([
            'message' => trans('global.created', ['attribute' => trans('saas.subscription.subscription')]),
            'subscription' => SubscriptionResource::make($subscription),
        ]);
    }

    public function fail(Request $request, SubscriptionService $service, PaymentGateway $paymentGateway)
    {
        $service->fail($request, $paymentGateway);

        return response()->error([
            'message' => trans('global.failed', ['attribute' => trans('saas.subscription.subscription')]),
        ]);
    }

    public function show(Subscription $subscription, SubscriptionService $service)
    {
        $subscription->isAccessible();

        return SubscriptionResource::make($subscription);
    }
}
