<?php

namespace App\Http\Requests\Saas;

use App\Rules\Username;
use Illuminate\Foundation\Http\FormRequest;

class InstallRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|min:2|max:100',
            'email' => 'required|email',
            'username' => ['required', 'max:50', new Username],
            'password' => 'required|same:password_confirmation',
            'activation_token' => 'required|uuid',
        ];
    }

    /**
     * Translate fields with user friendly name.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'name' => __('saas.props.name'),
            'email' => __('saas.props.email'),
            'username' => __('saas.props.username'),
            'password' => __('saas.props.password'),
            'activation_token' => __('saas.props.activation_token'),
        ];
    }
}
