<?php

namespace App\Http\Resources\Saas;

use App\Enums\Saas\PlanFrequency;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Arr;

class PlanResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'uuid' => $this->uuid,
            'name' => $this->name,
            'code' => $this->code,
            'description' => $this->description,
            'description_items' => $this->description_items,
            'is_active' => (bool) $this->getFeature('is_active'),
            'is_free' => (bool) $this->getFeature('is_free'),
            'is_default' => (bool) $this->getFeature('is_default'),
            'is_featured' => (bool) $this->getFeature('is_featured'),
            'is_visible' => (bool) $this->getFeature('is_visible'),
            'has_activation_charge' => (bool) $this->getFeature('has_activation_charge'),
            'allow_using_global_mail_service' => (bool) $this->getFeature('allow_using_global_mail_service'),
            'max_team_limit' => (int) $this->getFeature('max_team_limit'),
            'team_wise_limit' => (bool) $this->getFeature('team_wise_limit'),
            $this->mergeWhen($this->getFeature('team_wise_limit'), [
                'max_employee_per_team_limit' => (int) $this->getFeature('max_employee_per_team_limit'),
            ]),
            $this->mergeWhen(! $this->getFeature('team_wise_limit'), [
                'max_employee_limit' => (int) $this->getFeature('max_employee_limit'),
            ]),
            'enable_tax' => (bool) Arr::get($this->tax, 'is_enabled'),
            $this->mergeWhen(Arr::get($this->tax, 'is_enabled'), [
                'tax_label' => Arr::get($this->tax, 'label'),
                'tax_rate' => \Percent::from(Arr::get($this->tax, 'rate')),
                'tax_type_exclusive' => (bool) Arr::get($this->tax, 'is_exclusive'),
            ]),
            'price' => $this->getPrice(Arr::get($this->pricing, 'price', [])),
            'activation_charge' => $this->getActivationCharge(Arr::get($this->pricing, 'activation_charge', [])),
            'created_at' => \Cal::dateTime($this->created_at),
            'updated_at' => \Cal::dateTime($this->updated_at),
        ];
    }

    private function getPrice($price)
    {
        $currencies = explode(',', config('saas.landlord.system.currencies'));

        $prices = [];
        foreach ($currencies as $currencyName) {
            foreach (PlanFrequency::getKeys() as $frequency) {
                $frequencyPrice = Arr::get($price, $frequency);
                $amount = Arr::get($frequencyPrice, $currencyName, 0);
                $prices[] = [
                    'frequency' => PlanFrequency::getDetail($frequency),
                    'currency' => \Currency::from($currencyName),
                    'amount' => \Price::from($amount, $currencyName),
                ];
            }
        }

        return $prices;
    }

    private function getActivationCharge($price)
    {
        $currencies = explode(',', config('saas.landlord.system.currencies'));

        $prices = [];
        foreach ($currencies as $currencyName) {
            $amount = Arr::get($price, $currencyName, 0);
            $prices[] = [
                'currency' => \Currency::from($currencyName),
                'amount' => \Price::from($amount, $currencyName),
            ];
        }

        return $prices;
    }
}
