<?php

namespace App\Http\Resources\Saas;

use App\Enums\Saas\PlanFrequency;
use Illuminate\Http\Resources\Json\JsonResource;

class SubscriptionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'uuid' => $this->uuid,
            'code_number' => $this->code_number ?? '-',
            'reference_number' => $this->getMeta('reference_number') ?? '-',
            'is_online' => $this->getMeta('is_online') ? true : false,
            'plan' => PlanResource::make($this->whenLoaded('plan')),
            'amount' => $this->amount,
            'currency' => \Currency::from($this->currency),
            'frequency' => PlanFrequency::getDetail($this->frequency),
            'start_date' => $this->start_date,
            'expiry_date' => $this->expiry_date,
            'created_at' => \Cal::dateTime($this->created_at),
            'updated_at' => \Cal::dateTime($this->updated_at),
        ];
    }
}
