<?php

namespace App\Models\Saas;

use App\Casts\DateCast;
use App\Concerns\HasMeta;
use App\Enums\Saas\TenantStatus;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Tenant extends Model
{
    use HasFactory, HasMeta;

    protected $table = 'tenants';

    protected $casts = [
        'expiry_date' => DateCast::class,
        'status' => TenantStatus::class,
        'is_trial' => 'boolean',
        'meta' => 'array',
        'address' => 'array',
        'plan_details' => 'array',
    ];

    protected $connection = 'landlord';

    public function plan(): BelongsTo
    {
        return $this->belongsTo(Plan::class);
    }

    public function subscriptions(): HasMany
    {
        return $this->hasMany(Subscription::class);
    }

    public function subscription(): BelongsTo
    {
        return $this->belongsTo(Subscription::class);
    }

    public function scopeWithActiveSubscriptionId(Builder $query)
    {
        $query->addSelect(['subscription_id' => Subscription::select('id')
            ->whereColumn('tenant_id', 'tenants.id')
            ->where('status', '=', 1)
            ->where('start_date', '<=', today()->toDateString())
            ->orderBy('created_at', 'desc')
            ->limit(1),
        ]);
    }

    public function scopeWithActivePlanId(Builder $query)
    {
        $query->addSelect(['active_plan_id' => Subscription::select('plan_id')
            ->whereColumn('tenant_id', 'tenants.id')
            ->where('status', '=', 1)
            ->where('start_date', '<=', today()->toDateString())
            ->orderBy('created_at', 'desc')
            ->limit(1),
        ]);
    }
}
