<?php

namespace App\Scopes;

use App\Models\Employee\Employee;
use Illuminate\Database\Eloquent\Builder;

trait AudienceScope
{
    public function scopeAccessible(Builder $query, ?string $date = null)
    {
        if (auth()->user()->is_default || auth()->user()->hasRole('admin')) {
            return;
        }

        $date ??= today()->toDateString();

        $employee = Employee::query()
            ->record(true)
            ->first();

        if (! $employee) {
            $query->whereDoesntHave('audiences');

            return;
        }

        $query->whereHas('audiences', function ($q) use ($employee) {
            $q->where(function ($q) use ($employee) {
                $q->where('audienceable_type', 'Department')
                    ->where('audienceable_id', $employee->department_id);
            })->orWhere(function ($q) use ($employee) {
                $q->where('audienceable_type', 'Designation')
                    ->where('audienceable_id', $employee->designation_id);
            })->orWhere(function ($q) use ($employee) {
                $q->where('audienceable_type', 'Branch')
                    ->where('audienceable_id', $employee->branch_id);
            });
        });

        $query
            ->orWhere(function ($q) {
                $q->where('audience->employee_type', '=', 'all');
            });
    }
}
