<?php

namespace App\Support\Saas;

use App\Actions\Saas\CheckForTenant;
use App\Actions\Saas\CheckLandlordConnection;
use App\Actions\Saas\SetTenantConfig;
use App\Models\Saas\Tenant;
use Illuminate\Pipeline\Pipeline;

class SetTenant
{
    public function set()
    {
        if (! isset($_SERVER['HTTP_HOST'])) {
            return null;
        }

        app(Pipeline::class)
            ->send(new Tenant)
            ->through([
                CheckLandlordConnection::class,
                CheckForTenant::class,
                SetTenantConfig::class,
            ])
            ->thenReturn();
    }
}
