<?php

use App\Http\Controllers\Command\UpdateController;
use Illuminate\Support\Facades\Route;

Route::get('clear-cache', function () {
    \Artisan::call('optimize:clear');

    app(\Spatie\Permission\PermissionRegistrar::class)->forgetCachedPermissions();

    return view('index', ['message' => 'Cache cleared.']);
})->name('clear.cache');

Route::get('sync-template', function () {
    \Artisan::call('sync:template', ['tenant' => [config('saas.tenant.id')], '--force' => true]);

    return view('index', ['message' => 'Template synced.']);
})->name('sync.template');

Route::get('sync-permission', function () {
    \Artisan::call('sync:permission', ['tenant' => [config('saas.tenant.id')], '--force' => true]);

    return view('index', ['message' => 'Permission synced.']);
})->name('sync.permission');

Route::get('tenant:migrate', function () {
    \Artisan::call('migrate', ['tenant' => [config('saas.tenant.id')], '--force' => true]);

    return view('index', ['message' => 'Migration complete.']);
})->name('migrate');

Route::get('update', UpdateController::class)->name('update.app');
