<?php

use App\Http\Controllers\Employee\AccountController;
use App\Http\Controllers\Employee\AccountExportController;
use App\Http\Controllers\Employee\DocumentController;
use App\Http\Controllers\Employee\DocumentExportController;
use App\Http\Controllers\Employee\EditRequestController;
use App\Http\Controllers\Employee\EditRequestExportController;
use App\Http\Controllers\Employee\EmployeeExportController;
use App\Http\Controllers\Employee\ExperienceController;
use App\Http\Controllers\Employee\ExperienceExportController;
use App\Http\Controllers\Employee\ProfileEditRequestController;
use App\Http\Controllers\Employee\QualificationController;
use App\Http\Controllers\Employee\QualificationExportController;
use App\Http\Controllers\Employee\RecordController;
use App\Http\Controllers\Employee\RecordExportController;
use App\Http\Controllers\Employee\WorkShiftExportController;
use Illuminate\Support\Facades\Route;

Route::name('employee.')->prefix('employee')->group(function () {
    Route::get('edit-requests/{edit_request}/media/{uuid}', [EditRequestController::class, 'downloadMedia']);
    Route::get('edit-requests/export', EditRequestExportController::class)->middleware('permission:employee:edit-request-action')->name('edit-requests.export');
});

Route::prefix('employees')->group(function () {
    Route::get('{employee}/records/{record}/media/{uuid}', [RecordController::class, 'downloadMedia']);
    Route::get('{employee}/qualifications/{qualification}/media/{uuid}', [QualificationController::class, 'downloadMedia']);
    Route::get('{employee}/accounts/{account}/media/{uuid}', [AccountController::class, 'downloadMedia']);
    Route::get('{employee}/documents/{document}/media/{uuid}', [DocumentController::class, 'downloadMedia']);
    Route::get('{employee}/experiences/{experience}/media/{uuid}', [ExperienceController::class, 'downloadMedia']);

    Route::get('{employee}/records/export', RecordExportController::class)->middleware('permission:employment-record:manage')->name('employees.records.export');
    Route::get('{employee}/work-shifts/export', WorkShiftExportController::class)->middleware('permission:work-shift:assign')->name('employees.work-shifts.export');
    Route::get('{employee}/qualifications/export', QualificationExportController::class)->middleware('permission:employee:export')->name('employees.qualifications.export');
    Route::get('{employee}/accounts/export', AccountExportController::class)->middleware('permission:employee:export')->name('employees.accounts.export');
    Route::get('{employee}/documents/export', DocumentExportController::class)->middleware('permission:employee:export')->name('employees.documents.export');
    Route::get('{employee}/experiences/export', ExperienceExportController::class)->middleware('permission:employee:export')->name('employees.experiences.export');

    Route::get('{employee}/edit-requests/{edit_request}/media/{uuid}', [ProfileEditRequestController::class, 'downloadMedia']);

    Route::get('export', EmployeeExportController::class)->middleware('permission:employee:export')->name('employees.export');
});
