<?php

use App\Http\Controllers\Payroll\BulkExportPayrollController;
use App\Http\Controllers\Payroll\PayHeadExportController;
use App\Http\Controllers\Payroll\PaymentAdviceController;
use App\Http\Controllers\Payroll\PayrollController;
use App\Http\Controllers\Payroll\PayrollExportController;
use App\Http\Controllers\Payroll\SalarySheetController;
use App\Http\Controllers\Payroll\SalaryStructureExportController;
use App\Http\Controllers\Payroll\SalaryTemplateExportController;
use Illuminate\Support\Facades\Route;

Route::get('payrolls/export', PayrollExportController::class)->middleware('permission:payroll:export');

Route::get('payrolls/salary-sheet/export', SalarySheetController::class)->middleware('permission:payroll:export');
Route::get('payrolls/payment-advice/export', PaymentAdviceController::class)->middleware('permission:payroll:export');
Route::get('payrolls/bulk-export', BulkExportPayrollController::class)->middleware('permission:payroll:export');

Route::get('payrolls/{payroll}/export', [PayrollController::class, 'export'])->middleware('permission:payroll:export');

Route::get('payroll/pay-heads/export', PayHeadExportController::class)->middleware('permission:payroll:config')->name('payHeads.export');
Route::get('payroll/salary-templates/export', SalaryTemplateExportController::class)->middleware('permission:salary-template:export');
Route::get('payroll/salary-structures/export', SalaryStructureExportController::class)->middleware('permission:salary-structure:export');
