<?php

use App\Http\Controllers\Employee\AccountActionController;
use App\Http\Controllers\Employee\AccountController;
use App\Http\Controllers\Employee\DocumentActionController;
use App\Http\Controllers\Employee\DocumentController;
use App\Http\Controllers\Employee\EditRequestActionController;
use App\Http\Controllers\Employee\EditRequestController;
use App\Http\Controllers\Employee\EmployeeController;
use App\Http\Controllers\Employee\EmployeeImportController;
use App\Http\Controllers\Employee\ExperienceActionController;
use App\Http\Controllers\Employee\ExperienceController;
use App\Http\Controllers\Employee\PhotoController;
use App\Http\Controllers\Employee\ProfileEditRequestController;
use App\Http\Controllers\Employee\QualificationActionController;
use App\Http\Controllers\Employee\QualificationController;
use App\Http\Controllers\Employee\RecordController;
use App\Http\Controllers\Employee\UserController;
use App\Http\Controllers\Employee\WorkShiftController;
use Illuminate\Support\Facades\Route;

Route::name('employee.')->prefix('employee')->group(function () {
    Route::get('edit-requests/pre-requisite', [EditRequestController::class, 'preRequisite'])->name('edit-requests.preRequisite');

    Route::post('edit-requests/{edit_request}/action', [EditRequestActionController::class, 'action']);

    Route::apiResource('edit-requests', EditRequestController::class)->only(['index', 'show']);
});

Route::middleware('permission:employee:read')->group(function () {
    Route::post('employees/{employee}/user/confirm', [UserController::class, 'confirm'])->name('employees.confirmUser');
    Route::get('employees/{employee}/user', [UserController::class, 'index'])->name('employees.getUser');
    Route::post('employees/{employee}/user', [UserController::class, 'create'])->name('employees.createUser');
    Route::patch('employees/{employee}/user', [UserController::class, 'update'])->name('employees.updateUser');

    Route::post('employees/{employee}/photo', [PhotoController::class, 'upload'])
        ->name('employees.uploadPhoto');

    Route::delete('employees/{employee}/photo', [PhotoController::class, 'remove'])
        ->name('employees.removePhoto');

    Route::get('employees/{employee}/records/pre-requisite', [RecordController::class, 'preRequisite'])->name('employees.records.preRequisite');
    Route::apiResource('employees.records', RecordController::class);

    Route::get('employees/{employee}/work-shifts/pre-requisite', [WorkShiftController::class, 'preRequisite'])->name('employees.work-shifts.preRequisite');
    Route::apiResource('employees.work-shifts', WorkShiftController::class);

    Route::get('employees/{employee}/qualifications/pre-requisite', [QualificationController::class, 'preRequisite'])->name('employees.qualifications.preRequisite');
    Route::post('employees/{employee}/qualifications/{qualification}/action', [QualificationActionController::class, 'action']);
    Route::apiResource('employees.qualifications', QualificationController::class);

    Route::get('employees/{employee}/accounts/pre-requisite', [AccountController::class, 'preRequisite'])->name('employees.accounts.preRequisite');
    Route::post('employees/{employee}/accounts/{account}/action', [AccountActionController::class, 'action']);
    Route::post('employees/{employee}/accounts/{account}/make-primary', [AccountActionController::class, 'makePrimary'])->name('employees.accounts.makePrimary');
    Route::apiResource('employees.accounts', AccountController::class)->names('employees.accounts');

    Route::get('employees/{employee}/documents/pre-requisite', [DocumentController::class, 'preRequisite'])->name('employees.documents.preRequisite');
    Route::post('employees/{employee}/documents/{document}/action', [DocumentActionController::class, 'action']);
    Route::apiResource('employees.documents', DocumentController::class);

    Route::get('employees/{employee}/experiences/pre-requisite', [ExperienceController::class, 'preRequisite'])->name('employees.experiences.preRequisite');
    Route::post('employees/{employee}/experiences/{experience}/action', [ExperienceActionController::class, 'action']);
    Route::apiResource('employees.experiences', ExperienceController::class);

    Route::get('employees/pre-requisite', [EmployeeController::class, 'preRequisite'])->name('employees.preRequisite');
    Route::post('employees/import', EmployeeImportController::class)->middleware('permission:employees:create')->name('employees.import');

    Route::get('employees/{employee}/edit-requests', [ProfileEditRequestController::class, 'index'])->name('employees.editRequests.index');
    Route::post('employees/{employee}/edit-requests', [ProfileEditRequestController::class, 'store'])->name('employees.editRequests.store');
    Route::get('employees/{employee}/edit-requests/{uuid}', [ProfileEditRequestController::class, 'show'])->name('employees.editRequests.show');

    Route::apiResource('employees', EmployeeController::class);
});
